#ifndef CHANNELAPI
#define CHANNELAPI	__declspec(dllimport)
#endif

#ifndef CHANNEL_H
#define CHANNEL_H

#define CREATE_BUFFER2

#include <windows.h>

#include "..\Utilities\Util.h"

// Reserved message bytes, data at s[DATA_START]
#define DATA_START			6
#define MESSAGE_SIZE		4096

// Reserved fiels
#define MESSAGE_TYPE		1
#define SIZE_OF_MESSAGE		2


#define CLIENT	0
#define SERVER	1

// Field 1
// all other values are invalid
#define ADDRESS_REQUEST			0
#define ADDRESS_KNOWN			1
#define ADDRESS_UNKNOWN			2
#define NEED_BASE_OF_LIBRARIES	3
#define ADD_CLIENT				4

// buffers
#define BUFFER_SIZE_UNKNOWN		0

#ifdef CLIENT_DLL

#define SERVER_KILLED	0
#define SERVER_READY	1
#define CLIENT_OK		2

#else

#define CLIENT_KILLED	0
#define CLIENT_READY	1
#define SERVER_OK		2

#define IS_CLIENT_KILLED(i)		(((i) % 2) == CLIENT_KILLED)
#define IS_CLIENT_READY(i)		(((i) % 2) == CLIENT_READY)

/*
#define INDEX_CLIENT_KILLED(i)	(((i) / 2) + CLIENT_KILLED)
#define INDEX_CLIENT_READY(i)	(((i) / 2) + CLIENT_READY)
*/

#define INDEX_CLIENT_KILLED(i)	( ((i) / 2 ) * 2 + CLIENT_KILLED)
#define INDEX_CLIENT_READY(i)	( ((i) / 2 ) * 2 + CLIENT_READY)

#define INDEX(i)	((i) / 2)



#endif



#ifndef NOT_FUNCTIONS

CHANNELAPI HANDLE GetHandleToServer();
 
CHANNELAPI char *CreateChannel(int isClient);
CHANNELAPI void CloseChannel();
CHANNELAPI int Send();
CHANNELAPI int Receive();
CHANNELAPI CLEAN_STRING GetDynamicLinkerPath();
 
//CHANNELAPI void msg(char *lpMsgBuf);
//CHANNELAPI void error();

#ifdef CLIENT_DLL 
CHANNELAPI void SetHandleToServer(HANDLE hServer);
//CHANNELAPI int DoReq(CLEAN_STRING s);
CHANNELAPI CLEAN_STRING DoReqS(CLEAN_STRING s);
CHANNELAPI char *extract_dlink_path(char *path);

#ifdef STATIC_CLIENT_CHANNEL
CHANNELAPI BOOL replace_command_line(CLEAN_STRING s);
CHANNELAPI BOOL CleanNewKey(CLEAN_STRING key,CLEAN_STRING value);
#endif

#else
//CHANNELAPI void SetHandleToClient(HANDLE hClient);

CHANNELAPI void SetHandlesToClient(HANDLE hserver_ready, 
						HANDLE hclient_killed,
						HANDLE hclient_ready);
#endif

#ifdef CREATE_BUFFER2
typedef struct _BufferInfo {
	char *hView;
	HANDLE hMapping;
} BufferInfo, *PBufferInfo;

//CHANNELAPI void CreateBuffer(char *name, int size, BOOL open_buffer, **BufferInfo);
CHANNELAPI void CreateBuffer2(char *name, int size, BOOL open_buffer, BufferInfo *info);
CHANNELAPI void CloseBuffer2(BufferInfo *info);
#else
CHANNELAPI void CloseBuffer(char *hLibraryBufferView);
CHANNELAPI char *CreateBuffer(char *name, int size, BOOL open_buffer);
#endif

#endif


#ifdef CLIENT_DLL

#ifndef STATIC_CLIENT_CHANNEL

CHANNELAPI void InitClientDLL();
#endif
#endif
#endif

